/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.util.preset;

import energon.srpextra.config.SRPEConfigSystem;
import energon.srpextra.entity.IESpawnRule;
import energon.srpextra.init.SRPEPhases;
import energon.srpextra.util.preset.IGetRandomPos;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NPListGetRandomPos {
    public static Map<Integer, IGetRandomPos> RANDOM_POS = new HashMap<Integer, IGetRandomPos>();
    public static IGetRandomPos BASIC;
    public static IGetRandomPos ADV;
    public static IGetRandomPos CASUAL;
    public static IGetRandomPos TEST;
    public static IGetRandomPos SUMMON_UP;
    public static IGetRandomPos SUMMON_CENTER;
    public static IGetRandomPos SUMMON_DOWN;

    public static void init() {
        BASIC = new BASIC();
        RANDOM_POS.putIfAbsent(0, BASIC);
        ADV = new ADV();
        RANDOM_POS.putIfAbsent(1, ADV);
        CASUAL = new CASUAL();
        RANDOM_POS.putIfAbsent(2, CASUAL);
        TEST = new TEST();
        RANDOM_POS.putIfAbsent(3, TEST);
        SUMMON_UP = new SUMMON_DOWN();
        RANDOM_POS.putIfAbsent(97, SUMMON_UP);
        SUMMON_CENTER = new SUMMON_DOWN();
        RANDOM_POS.putIfAbsent(98, SUMMON_CENTER);
        SUMMON_DOWN = new SUMMON_DOWN();
        RANDOM_POS.putIfAbsent(99, SUMMON_DOWN);
    }

    public static class SUMMON_DOWN
    implements IGetRandomPos {
        @Override
        public BlockPos getRandomPos(World world, BlockPos pos, Random random, byte phase, @Nullable SRPEPhases.PhaseUtilsValues value, @Nonnull IESpawnRule spawnRule) {
            int randomXPos = random.nextInt(7) - 3;
            int randomZPos = random.nextInt(7) - 3;
            pos = pos.func_177982_a(randomXPos, 0, randomZPos);
            int yTest = pos.func_177956_o();
            int levelMaxY = world.func_72800_K();
            int levelMinY = 3;
            for (int y = 3; y > -12 && levelMinY < y + yTest && y + yTest < levelMaxY; --y) {
                switch (spawnRule.canSpawnHere(world, pos.func_177981_b(y), phase)) {
                    case 1: {
                        return pos.func_177981_b(y);
                    }
                    case 3: {
                        return null;
                    }
                }
            }
            return null;
        }
    }

    public static class SUMMON_CENTER
    implements IGetRandomPos {
        @Override
        public BlockPos getRandomPos(World world, BlockPos pos, Random random, byte phase, @Nullable SRPEPhases.PhaseUtilsValues value, @Nonnull IESpawnRule spawnRule) {
            int randomXPos = random.nextInt(7) - 3;
            int randomZPos = random.nextInt(7) - 3;
            pos = pos.func_177982_a(randomXPos, 0, randomZPos);
            int yTest = pos.func_177956_o();
            int levelMaxY = world.func_72800_K();
            int levelMinY = 3;
            for (int y = 5; y > -5 && levelMinY < y + yTest && y + yTest < levelMaxY; --y) {
                switch (spawnRule.canSpawnHere(world, pos.func_177981_b(y), phase)) {
                    case 1: {
                        return pos.func_177981_b(y);
                    }
                    case 3: {
                        return null;
                    }
                }
            }
            return null;
        }
    }

    public static class SUMMON_UP
    implements IGetRandomPos {
        @Override
        public BlockPos getRandomPos(World world, BlockPos pos, Random random, byte phase, @Nullable SRPEPhases.PhaseUtilsValues value, @Nonnull IESpawnRule spawnRule) {
            int randomXPos = random.nextInt(7) - 3;
            int randomZPos = random.nextInt(7) - 3;
            pos = pos.func_177982_a(randomXPos, 0, randomZPos);
            int yTest = pos.func_177956_o();
            int levelMaxY = world.func_72800_K();
            int levelMinY = 3;
            for (int y = 12; y > -3 && levelMinY < y + yTest && y + yTest < levelMaxY; --y) {
                switch (spawnRule.canSpawnHere(world, pos.func_177981_b(y), phase)) {
                    case 1: {
                        return pos.func_177981_b(y);
                    }
                    case 3: {
                        return null;
                    }
                }
            }
            return null;
        }
    }

    public static class TEST
    implements IGetRandomPos {
        @Override
        public BlockPos getRandomPos(World world, BlockPos pos, Random random, byte phase, @Nullable SRPEPhases.PhaseUtilsValues value, @Nonnull IESpawnRule spawnRule) {
            int randomZPos;
            int randomYPos = random.nextInt(97) - 48;
            int randomXPos = random.nextInt(125) - 64;
            if (world.func_184137_a((double)(pos = pos.func_177982_a(randomXPos, randomYPos, randomZPos = randomYPos * randomYPos > 250 ? random.nextInt(125) - 64 : (randomXPos * randomXPos > 300 ? random.nextInt(125) - 64 : (random.nextInt(40) + 24) * (random.nextBoolean() ? 1 : -1)))).func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 24.0, false) != null) {
                return null;
            }
            if (value != null) {
                if (!value.distanceWCheck(world, pos)) {
                    return null;
                }
                if (!value.biomeCheck(world, pos)) {
                    return null;
                }
            }
            int yTest = pos.func_177956_o();
            int levelMaxY = Math.min(world.func_72800_K(), SRPEConfigSystem.maxYCoordinateParasiteSpawn);
            int levelMinY = Math.max(1, SRPEConfigSystem.minYCoordinateParasiteSpawn);
            int y = 0;
            int step = 1;
            while (y * y < 144) {
                int n = y = step % 2 == 0 ? -step / 2 : step / 2;
                if (levelMinY < y + yTest && y + yTest < levelMaxY) {
                    switch (spawnRule.canSpawnHere(world, pos.func_177981_b(y), phase)) {
                        case 1: {
                            return pos.func_177981_b(y);
                        }
                        case 3: {
                            return null;
                        }
                    }
                }
                ++step;
            }
            return null;
        }
    }

    public static class CASUAL
    implements IGetRandomPos {
        @Override
        public BlockPos getRandomPos(World world, BlockPos pos, Random random, byte phase, @Nullable SRPEPhases.PhaseUtilsValues value, @Nonnull IESpawnRule spawnRule) {
            int randomXPos = random.nextInt(SRPEConfigSystem.maxDistanceSpawnEntity * 2 + 1) - SRPEConfigSystem.maxDistanceSpawnEntity;
            int randomZPos = random.nextInt(SRPEConfigSystem.maxDistanceSpawnEntity * 2 + 1) - SRPEConfigSystem.maxDistanceSpawnEntity;
            int randomYPos = random.nextInt(SRPEConfigSystem.maxDistanceSpawnEntityAboveAndBelow * 2 + 1) - SRPEConfigSystem.maxDistanceSpawnEntityAboveAndBelow;
            if (world.func_184137_a((double)(pos = pos.func_177982_a(randomXPos, randomYPos, randomZPos)).func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(SRPEConfigSystem.minDistanceSpawnEntity - 4), false) != null) {
                return null;
            }
            if (value != null) {
                if (!value.distanceWCheck(world, pos)) {
                    return null;
                }
                if (!value.biomeCheck(world, pos)) {
                    return null;
                }
            }
            int yTest = pos.func_177956_o();
            int levelMaxY = Math.min(world.func_72800_K(), SRPEConfigSystem.maxYCoordinateParasiteSpawn);
            int levelMinY = Math.max(1, SRPEConfigSystem.minYCoordinateParasiteSpawn);
            int y = 0;
            int step = 1;
            while (y * y < 144) {
                int n = y = step % 2 == 0 ? -step / 2 : step / 2;
                if (levelMinY < y + yTest && y + yTest < levelMaxY) {
                    switch (spawnRule.canSpawnHere(world, pos.func_177981_b(y), phase)) {
                        case 1: {
                            return pos.func_177981_b(y);
                        }
                        case 3: {
                            return null;
                        }
                    }
                }
                ++step;
            }
            return null;
        }
    }

    public static class BASIC
    implements IGetRandomPos {
        @Override
        public BlockPos getRandomPos(World world, BlockPos pos, Random random, byte phase, @Nullable SRPEPhases.PhaseUtilsValues value, @Nonnull IESpawnRule spawnRule) {
            int randomZPos;
            int randomYPos;
            int randomXPos = random.nextInt(SRPEConfigSystem.maxDistanceSpawnEntity * 2 + 1) - SRPEConfigSystem.maxDistanceSpawnEntity;
            if (world.func_184137_a((double)(pos = pos.func_177982_a(randomXPos, randomYPos = random.nextInt(SRPEConfigSystem.maxDistanceSpawnEntityAboveAndBelow * 2 + 1) - SRPEConfigSystem.maxDistanceSpawnEntityAboveAndBelow, randomZPos = randomXPos * randomXPos > SRPEConfigSystem.minDistanceSpawnEntity * SRPEConfigSystem.minDistanceSpawnEntity ? random.nextInt(SRPEConfigSystem.maxDistanceSpawnEntity * 2 + 1) - SRPEConfigSystem.maxDistanceSpawnEntity : (random.nextInt(SRPEConfigSystem.maxDistanceSpawnEntity - SRPEConfigSystem.minDistanceSpawnEntity + 1) + SRPEConfigSystem.minDistanceSpawnEntity) * (random.nextBoolean() ? 1 : -1))).func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(SRPEConfigSystem.minDistanceSpawnEntity - 2), false) != null) {
                return null;
            }
            if (value != null) {
                if (!value.distanceWCheck(world, pos)) {
                    return null;
                }
                if (!value.biomeCheck(world, pos)) {
                    return null;
                }
            }
            int yTest = pos.func_177956_o();
            int levelMaxY = Math.min(world.func_72800_K(), SRPEConfigSystem.maxYCoordinateParasiteSpawn);
            int levelMinY = Math.max(1, SRPEConfigSystem.minYCoordinateParasiteSpawn);
            int y = 0;
            int step = 1;
            while (y * y < 144) {
                int n = y = step % 2 == 0 ? -step / 2 : step / 2;
                if (levelMinY < y + yTest && y + yTest < levelMaxY) {
                    switch (spawnRule.canSpawnHere(world, pos.func_177981_b(y), phase)) {
                        case 1: {
                            return pos.func_177981_b(y);
                        }
                        case 3: {
                            return null;
                        }
                    }
                }
                ++step;
            }
            return null;
        }
    }

    public static class ADV
    implements IGetRandomPos {
        @Override
        public BlockPos getRandomPos(World world, BlockPos pos, Random random, byte phase, @Nullable SRPEPhases.PhaseUtilsValues value, @Nonnull IESpawnRule spawnRule) {
            int randomYPos;
            int randomZPos;
            int randomXPos = random.nextInt(SRPEConfigSystem.maxDistanceSpawnEntity * 2 + 1) - SRPEConfigSystem.maxDistanceSpawnEntity;
            if (randomXPos * randomXPos > SRPEConfigSystem.minDistanceSpawnEntity * SRPEConfigSystem.minDistanceSpawnEntity) {
                randomZPos = random.nextInt(SRPEConfigSystem.maxDistanceSpawnEntity * 2 + 1) - SRPEConfigSystem.maxDistanceSpawnEntity;
                randomYPos = randomZPos * randomZPos > SRPEConfigSystem.minDistanceSpawnEntity * SRPEConfigSystem.minDistanceSpawnEntity ? random.nextInt(SRPEConfigSystem.maxDistanceSpawnEntityAboveAndBelow * 2 + 1) - SRPEConfigSystem.maxDistanceSpawnEntityAboveAndBelow : (random.nextInt(SRPEConfigSystem.maxDistanceSpawnEntityAboveAndBelow - SRPEConfigSystem.minDistanceSpawnEntityAboveAndBelow + 1) + SRPEConfigSystem.minDistanceSpawnEntityAboveAndBelow) * (random.nextBoolean() ? 1 : -1);
            } else {
                randomZPos = (random.nextInt(SRPEConfigSystem.maxDistanceSpawnEntity - SRPEConfigSystem.minDistanceSpawnEntity + 1) + SRPEConfigSystem.minDistanceSpawnEntity) * (random.nextBoolean() ? 1 : -1);
                randomYPos = (random.nextInt(SRPEConfigSystem.maxDistanceSpawnEntityAboveAndBelow - SRPEConfigSystem.minDistanceSpawnEntityAboveAndBelow + 1) + SRPEConfigSystem.minDistanceSpawnEntityAboveAndBelow) * (random.nextBoolean() ? 1 : -1);
            }
            pos = pos.func_177982_a(randomXPos, randomYPos, randomZPos);
            if (world.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(SRPEConfigSystem.minDistanceSpawnEntityAboveAndBelow - 2), false) != null) {
                return null;
            }
            if (value != null) {
                if (!value.distanceWCheck(world, pos)) {
                    return null;
                }
                if (!value.biomeCheck(world, pos)) {
                    return null;
                }
            }
            int yTest = pos.func_177956_o();
            int levelMaxY = Math.min(world.func_72800_K(), SRPEConfigSystem.maxYCoordinateParasiteSpawn);
            int levelMinY = Math.max(1, SRPEConfigSystem.minYCoordinateParasiteSpawn);
            int y = 0;
            int step = 1;
            while (y * y < 144) {
                int n = y = step % 2 == 0 ? -step / 2 : step / 2;
                if (levelMinY < y + yTest && y + yTest < levelMaxY) {
                    switch (spawnRule.canSpawnHere(world, pos.func_177981_b(y), phase)) {
                        case 1: {
                            return pos.func_177981_b(y);
                        }
                        case 3: {
                            return null;
                        }
                    }
                }
                ++step;
            }
            return null;
        }
    }
}

